/**
 * OWASP AppSensor
 * 
 * This file is part of the Open Web Application Security Project (OWASP)
 * AppSensor project. For details, please see
 * <a href="http://www.owasp.org/index.php/Category:OWASP_AppSensor_Project">
 * 	http://www.owasp.org/index.php/Category:OWASP_AppSensor_Project</a>.
 *
 * Copyright (c) 2010 - The OWASP Foundation
 * 
 * AppSensor is published by OWASP under the BSD license. You should read and accept the
 * LICENSE before you use, modify, and/or redistribute this software.
 * 
 * @author Michael Coates <a href="http://www.aspectsecurity.com">Aspect Security</a>
 * @author John Melton <a href="http://www.jtmelton.com/">jtmelton</a>
 * @created 2010
 */
namespace org.owasp.appsensor.trendmonitoring
{

    /**
     * The trend logger interface is a very simple interface that provides 
     * a method to log a TrendEvent.  Implementations of this method could vary
     * greatly depending upon the desired usage of the system.  Each implementation 
     * should log to a resource that is actively monitored in order to make decisions
     * regarding user and system trends that are considered to be an attack.  At that 
     * point, an exception matching the appropriate detection point should be created. 
     * <p>
     * A sample of a few possible implementations might be: 
     * <ul>
     * <li>In memory logger - log to some simple data store in memory that is cleared everytime the application is restarted.</li>
     * <li>File logger - log all output to a log file(s).  </li>
     * <li>DB logger - log all output to a Database</li>
     * <li>Knowledge system logger - this logger might log to an application engine of sometime that would keep track of all events and make decisions.</li>
     * </ul>
     * 
     * @author Michael Coates (michael.coates .at. owasp.org) 
     *         <a href="http://www.aspectsecurity.com">Aspect Security</a>
     * @author John Melton (jtmelton .at. gmail.com)
     *         <a href="http://www.jtmelton.com/">jtmelton</a>
     * @since June 17, 2010
     */
    public interface TrendLogger
    {
        void Log(TrendEvent e);
    }
}